import { world, system, EntityEquippableComponent, EquipmentSlot } from "@minecraft/server";

const DIVING_GEAR = [
    "thelake:diving_mask",
    "thelake:scuba_tank",
    "thelake:diving_suit_leggings",
    "thelake:flippers"
];

function checkDivingGear(player) {
    const equippable = player.getComponent(EntityEquippableComponent.componentId);
    if (!equippable) return false;

    const armorSlots = [
        equippable.getEquipment(EquipmentSlot.Head),
        equippable.getEquipment(EquipmentSlot.Chest),
        equippable.getEquipment(EquipmentSlot.Legs),
        equippable.getEquipment(EquipmentSlot.Feet)
    ];

    return armorSlots.every((item, index) => item?.typeId === DIVING_GEAR[index]);
}

function applyConduitPower(player) {
    player.addEffect("conduit_power", 200, { amplifier: 0, showParticles: false });
}

function removeConduitPower(player) {
    player.removeEffect("conduit_power");
}

system.runInterval(() => {
    for (const player of world.getAllPlayers()) {
        if (checkDivingGear(player)) {
            applyConduitPower(player);
        } else {
            removeConduitPower(player);
        }
    }
}, 10);